<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Borrowed Books</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
</head>
<body>
    <div class="container mt-5">
        <h2>Borrowed Books</h2>
        
        <div class="form-group">
            <label for="searchInput">Search by Registration Number:</label>
            <div class="input-group">
                <input type="text" id="searchInput" class="form-control" placeholder="Enter registration number">
                <div class="input-group-append">
                    <button class="btn btn-primary" id="searchButton">Search</button>
                </div>
            </div>
        </div>

        <table class="table table-bordered">
            <thead>
                <tr>
                    <th> Id </td>
                    <th>Registration Number</th>
                    <th>Class</th>
                    <th>Book Number</th>
                    <th>Book Title</th>
                    <th>Author</th>
                    <th>Borrow Date</th>
                    <th>Due Date</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody id="booksTableBody">
                <!-- Data will be populated here via AJAX -->
            </tbody>
        </table>
    </div>

    <script>
        $(document).ready(function() {
            // Function to fetch and display data
            function fetchData(registrationNumber = '') {
                $.ajax({
                    url: 'fetch_books.php', // PHP script to fetch data
                    method: 'GET',
                    data: { registration_number: registrationNumber }, // Send search parameter
                    success: function(data) {
                        $('#booksTableBody').html(data);
                    },
                    error: function() {
                        $('#booksTableBody').html('<tr><td colspan="8" class="text-danger">Error fetching data.</td></tr>');
                    }
                });
            }

            // Initial data fetch
            fetchData();

            // Search button click event
            $('#searchButton').on('click', function() {
                const searchValue = $('#searchInput').val().trim();
                fetchData(searchValue); // Fetch data with the search term
            });
        });

        // Function to delete a book
        function deleteBook(id) {
            if (confirm('Are you sure you want to delete this book?')) {
                $.ajax({
                    url: 'delete_book.php', // PHP script to handle deletion
                    method: 'POST',
                    data: { id: id },
                    success: function(response) {
                        alert(response);
                        fetchData(); // Refresh the data
                    },
                    error: function() {
                        alert('Error deleting book.');
                    }
                });
            }
        }
    </script>

    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>